using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

	/* Hierarchische Listenstrukturen am Beispiel (simulierter) Dateien und Ordner.
		SingleEntry = einzelne Datei, Basisklasse
		ListEntry = Verzeichnis, fhrt eine Liste mit Single- und ListEntry-Elementen

		Die Struktur wird per Zufallsgenerator aufgebaut, wobei die Wahrscheinlichkeit
		fr das Erzeugen neuer ListEntry-Elemente mit jeder zustzlichen Hierarchie-
		Ebene sinkt:
			if (Random(10*Level) < 1) then <New List, Rekursion mit Level+1>
			 else <New Single Entry>
		Das Element der obersten Ebene ist eine Liste, entspricht dem Stammverzeichnis.

		Untersucht das Laufzeitverhalten von
		- Objektverwaltung (1 Mio Objekte)
		- Stringmanipulationen
		- Listen bzw. Arrays (24 Millionen Suchvorgnge)
		- Random-Generator
		- Stackverwaltung
	*/

namespace ListList_CSharp_2000
	{
		/// <summary>
		/// Zusammenfassung fr Form1.
		/// </summary>
		public class LLForm : System.Windows.Forms.Form
		{
			private System.Windows.Forms.Button bCreateTree;
			private System.Windows.Forms.Button bBenchCreate;
			private System.Windows.Forms.ListBox listBox1;
			/// <summary>
			/// Erforderliche Designervariable.
			/// </summary>
			private System.ComponentModel.Container components = null;

			public LLForm()
			{
				//
				// Erforderlich fr die Windows Form-Designeruntersttzung
				//
				InitializeComponent();

				//
				// TODO: Fgen Sie den Konstruktorcode nach dem Aufruf von InitializeComponent hinzu
				//
			}

			/// <summary>
			/// Die verwendeten Ressourcen bereinigen.
			/// </summary>
			protected override void Dispose( bool disposing )
			{
				if( disposing )
				{
					if (components != null) 
					{
						components.Dispose();
					}
				}
				base.Dispose( disposing );
			}

		#region Vom Windows Form-Designer generierter Code
			/// <summary>
			/// Erforderliche Methode fr die Designeruntersttzung. 
			/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
			/// </summary>
			private void InitializeComponent()
			{
        this.bCreateTree = new System.Windows.Forms.Button();
        this.bBenchCreate = new System.Windows.Forms.Button();
        this.listBox1 = new System.Windows.Forms.ListBox();
        this.SuspendLayout();
        // 
        // bCreateTree
        // 
        this.bCreateTree.Location = new System.Drawing.Point(24, 8);
        this.bCreateTree.Name = "bCreateTree";
        this.bCreateTree.Size = new System.Drawing.Size(184, 23);
        this.bCreateTree.TabIndex = 0;
        this.bCreateTree.Text = "bCreateTree (100 Entries)";
        this.bCreateTree.Click += new System.EventHandler(this.bCreateTree_Click);
        // 
        // bBenchCreate
        // 
        this.bBenchCreate.Location = new System.Drawing.Point(24, 48);
        this.bBenchCreate.Name = "bBenchCreate";
        this.bBenchCreate.Size = new System.Drawing.Size(184, 23);
        this.bBenchCreate.TabIndex = 2;
        this.bBenchCreate.Text = "bBenchCreate (1 Mio Entries)";
        this.bBenchCreate.Click += new System.EventHandler(this.bBenchCreate_Click);
        // 
        // listBox1
        // 
        this.listBox1.Location = new System.Drawing.Point(8, 88);
        this.listBox1.Name = "listBox1";
        this.listBox1.Size = new System.Drawing.Size(216, 303);
        this.listBox1.TabIndex = 3;
        // 
        // LLForm
        // 
        this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
        this.ClientSize = new System.Drawing.Size(232, 405);
        this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                    this.listBox1,
                                                                    this.bBenchCreate,
                                                                    this.bCreateTree});
        this.Name = "LLForm";
        this.Text = "C#: ListList";
        this.ResumeLayout(false);

      }
		#endregion

			/// <summary>
			/// Der Haupteinstiegspunkt fr die Anwendung.
			/// </summary>
			[STAThread]
			static void Main() 
			{
				Application.Run(new LLForm());
			}

			TListEntry RootDir = null; // "Stammverzeichnis"
			int EntryCount; // Runterzhler frs Anlegen der Struktur
			Random Rand = new Random();

			private void BuildListList(TListEntry List, int Level)
			{ // Listenaufbau (rekursiv)
				int LocalCount = Rand.Next(25)+1;
				int NameLength;
				TSingleEntry NewEntry;
				string NewName;
		
				// maximal 25 Eintrge pro Liste - nur das Stammverzeichnis
				// kann mehr haben
				for (int x = 1; x <= LocalCount; x++)
				{
					EntryCount--;
					// zuflliger Name mit 1-8 Zeichen
					NameLength = Rand.Next(8)+1;
					NewName = "";
					for (int y = 1; y <= NameLength; y++)
						NewName = NewName + (char)((int)'a' + Rand.Next(26));
					// Einzelner Eintrag oder neue Liste? Die Wahrscheinlichkeit
					// fr neue Listen (und weitere Rekursion) sinkt mit zunehmender
					// Verschachelungstiefe
					if (Rand.Next(10*Level) < 1)
					{  // neue Liste
						NewEntry = new TListEntry();
						BuildListList((TListEntry)NewEntry, Level+1);
					}
					else 
						NewEntry = new TSingleEntry();
					NewEntry.EntryName = NewName;

					List.EntryList.Add(NewEntry);
					NewEntry.ParentList = List;

					if (EntryCount <= 0)
						break;
				}
			}


      private void ClearList()
      {
        // neu besetzen = die gesamte Struktur abrumen
        RootDir = new TListEntry();
        RootDir.EntryName = "C:";
				GC.Collect();
      }
			private void BuildBaseList(int ECount)
			{ // Legt die Elementenzahl fest und erzeugt das Stammverzeichnis
				EntryCount = ECount;
				while (EntryCount > 0)
					BuildListList(RootDir,1);
			}

			private void bCreateTree_Click(object sender, System.EventArgs e)
			{ 
				// Demo-Liste mit 100 Elementen, Anzeige
				listBox1.Items.Clear();
        ClearList();
				BuildBaseList(100); 
				PrintListList(RootDir, 1);
				ClearList();
			}

			private void ShowEntry(string S)
			{  // Anzeige in der Listbox, auch fr Suchergebnisse
				listBox1.Items.Add(S);
			}

			private void PrintListList(TListEntry List, int Level)
			{ // Ausgabe der Demo-Liste (100 Elemente)
				string Lead = "";
				TSingleEntry E;

				for (int x = 1; x < Level; x++)
					Lead = Lead + "  ";
				ShowEntry(Lead+ List.EntryName+" ###"); // Verzeichnisname
				Lead = Lead + "  "; // Dateinamen eingerckt
				// Dateieintrge und Verzeichnisse, ungeordnet
				for (int x = 0; x < List.EntryList.Count; x++)
				{ 
					E = (TSingleEntry)List.EntryList[x];
					if (E.IsList) PrintListList((TListEntry)E, Level+1);
					else ShowEntry(Lead+E.EntryName);
				}

			}

			// Durchsucht die Struktur rekursiv und liefert den vollstndigen
			// Pfad des ersten Vorkommens von SubStr zurck. Aufruf "von auen" mit RootDir
			private string FindListEntry(TListEntry List, string SubStr)
			{ TSingleEntry E = FindEntry(List, SubStr);

				if (E != null) return E.FullName();
				 else return "";
			}

			private TSingleEntry FindEntry(TListEntry List, string SubStr)
			{ TSingleEntry Result = null;

				// Einzelne Eintrge und Listennamen
				foreach(TSingleEntry E in List.EntryList)
				{
					
//					if (E.EntryName.IndexOf(SubStr) != -1)
//					if (E.EntryName.StartsWith(SubStr))
					if (E.EntryName == SubStr)
					{
						Result = E;
						break;
					}
				}
				// Rekursion fr Listen, falls noch nichts gefunden
				if (Result == null)
				{
					foreach (TSingleEntry E in List.EntryList)
						if (E.IsList)
						{
							Result = FindEntry((TListEntry)E, SubStr);
							if (Result != null)
								break;
						}
				}
				return(Result);
			}

			[System.Runtime.InteropServices.DllImport("winmm.dll")]
			private static extern int timeGetTime();

			// 1 Million Objekte, 24 Millionen Suchvorgnge
			private void bBenchCreate_Click(object sender, System.EventArgs e)
			{
        listBox1.Items.Clear();
        TimeSpan fullBench = new TimeSpan(0);
        TimeSpan constructionTime = new TimeSpan(0);
        TimeSpan destructionTime = new TimeSpan(0);      
        TimeSpan findTime = new TimeSpan(0);      
        DateTime start;
        DateTime meanTime; 
			
				ClearList(); // synchrone Freigabe
				start = DateTime.Now;

        for (int x = 1; x <= 10; x++)
        {
          meanTime = DateTime.Now; 
          BuildBaseList(100000);
          constructionTime += (DateTime.Now - meanTime);
          meanTime = DateTime.Now; 
          ShowEntry("Search a: " + FindListEntry(RootDir, "a"));
					ShowEntry("Search ax: " + FindListEntry(RootDir, "ax"));
					ShowEntry("Search axv: " + FindListEntry(RootDir, "axv"));
					ShowEntry("Search axve: " + FindListEntry(RootDir, "axve"));
					for (int y = 1; y <= 20; y++)
						FindListEntry(RootDir,"X"); // gibts nicht
          findTime += (DateTime.Now - meanTime);
					listBox1.Update();  // Lebenszeichen
          meanTime = DateTime.Now;
					ClearList(); 
					destructionTime += (DateTime.Now - meanTime);
				}
        MessageBox.Show("Time:\t\t"+(DateTime.Now-start +
          "\nfor Construction:\t"+ constructionTime +
          "\nfor Destruction:\t"+ destructionTime +
          "\nfor Find:\t\t"+ findTime), this.Text);
      }
		}

	public class TSingleEntry // einzelnes Element
	{
		protected bool FIsList;
		public TSingleEntry ParentList;
		public string EntryName;
		public bool IsList { get { return FIsList; } }
		public string FullName()
		{
			if (ParentList != null) return ParentList.FullName()+'\\'+ EntryName;
			else return EntryName;
		}
	}

		public class TListEntry : TSingleEntry // Verzeichnis
		{
			public ArrayList EntryList = null;  // TSingleEntry und TListEntry gemischt

			public TListEntry()
			{
				EntryList = new ArrayList();
				FIsList = true;
			}
	
		}

	}
